<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Include the configuration files.
require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");

// Make sure the person is logged in.
require ("./loginverify.php");

/*
 * Include the functions. Start the page timer, output the opening HTML,
 * and verify that we can actually connect to the database.
*/
require ("./functions.php");
	$start_time = micro_time(0);
	bodyHeader('click_info', $version_num);
	bodyNavigation('click_info');
	check_db_connection($adlogger_db_connect, $adlogger_db_select);

if (isset($_GET['id']) && !empty($_GET['id'])) {

	$click_id = mysql_real_escape_string($_GET['id']);
		if (!is_numeric($click_id)) {
			echo '<div id="main-copy">' .
					'<h1>Error!</h1>' .
					'<p>Invalid entry. Click ID must be numerical.</p>' .
				'</div>';
			bodyFooter('error', $start_time);
			exit();
		}

} else {

	echo '<div id="main-copy">' .
			'<h1>Error!</h1>' .
			'<p>There was an error processing your request. The click ID was not specified.</p>' .
		'</div>';
	bodyFooter('error', $start_time);
	exit();

}

/*
 * Query the database to find out the information about that click.
 * Also, join the channel table to find out the name and description
 * of the channel id.
 */
$query = "
	SELECT *
		FROM " . $db_table_prefix . "logfiles
			LEFT JOIN " . $db_table_prefix . "channels
				ON " . $db_table_prefix . "logfiles.ch_id = " . $db_table_prefix . "channels.id
					WHERE " . $db_table_prefix . "logfiles.id = '$click_id'
						";

	$result = mysql_query($query)
			or die(mysql_error());

		$results_num = mysql_num_rows($result);
			if ($results_num == 0) {
				echo '<div id="main-copy">' .
						'<h1>Error!</h1>' .
						'<p>Invalid entry. No data for that click ID.</p>' .
					'</div>';
				bodyFooter('error', $start_time);
				exit();
			}

	$row = mysql_fetch_array($result);
		$timestamp = $row['timestamp'];
				$date = date('l, F jS, Y', $timestamp);
				$time = date('g:i:s A', $timestamp);
		$visitor_ip = $row["visitor_ip"];
		$visitor_hostname = gethostbyaddr($visitor_ip);
		$visitor_agent = $row['visitor_agent'];
		$ch_id = $row['ch_id'];
		$disp_url = $row['disp_url'];
		$ref = $row['ref'];
		$targ_url = $row['targ_url'];

		$disp_time = $row['disp_time'];
		$ad_format = $row['format'];
			$ad_width = convertAdFormat($ad_format, 'width');
			$ad_height = convertAdFormat($ad_format, 'height');		
		$color_bg = $row['color_bg'];
		$color_txt = $row['color_txt'];
		$color_lnk = $row['color_lnk'];
		$color_url = $row['color_url'];
		$color_brd = $row['color_brd'];
		$ad_type = $row['ad_type'];

		$chan_name = $row['chan_name'];
		$chan_desc = $row['chan_desc'];
?>

<div id="side-bar">
	<div>
		<p class="sideBarTitle">Detailed Visitor Info</p>
		<ul>
			<li><a href="#click_info">&rsaquo; Click Information</a></li>
			<li><a href="#visitor_info">&rsaquo; Visitor Information</a></li>
			<li><a href="#other_info">&rsaquo; Other Information</a></li>
			<li><a href="#visitor_stats">&rsaquo; Visitor Stats</a></li>
			<li><a href="#visitor_blocks">&rsaquo; Visitor Blocks</a></li>
			<li><a href="#manage-logs">&rsaquo; Manage Click Logs</a></li>
		</ul>
	</div>
</div>

<div id="main-copy">
	<h1 id="click_info">Click Information</h1>
	<br />
		<table summary="click_info" width="75%" id="greytable">
			<tbody id="greytbody">
				<tr class="odd">
					<td width="30%">Click Number:</td>
					<td width="70%"><?php echo $click_id; ?></td>
				</tr>
				<tr>
					<td>Date and Time of Click:</td>
					<td><?php echo $time . " on " . $date; ?></td>
				</tr>
				<tr class="odd">
					<td>Display Page URL:</td>
					<td><?php echo shortenURL($disp_url); ?></td>
				</tr>
				<tr class="odd">
					<td>Referer:</td>
					<!--
						FYI: I did not spell "referer" incorrectly here.

						"Referer is a common misspelling of the word referrer.
						It is so common, in fact, that it made it into the official specification
						of HTTP  the communication protocol of the World Wide Web  and has
						therefore become the standard industry spelling when discussing HTTP referers."

						From: http://en.wikipedia.org/w/index.php?title=HTTP_referer&oldid=96304364
					-->
					<td><?php echo shortenURL($ref); ?></td>
				</tr>
				<tr class="odd">
					<td>Ad Target URL:</td>
					<td><?php echo unset_if_string_empty($targ_url); ?></td>
				</tr>
				<tr class="odd">
					<td>AdLogger Channel Name:</td>
					<td><?php echo unset_if_string_empty($chan_name); ?></td>
				</tr>
				<tr class="odd">
					<td>AdLogger Channel Description:</td>
					<td><?php echo unset_if_string_empty($chan_desc); ?></td>
				</tr>
			</tbody>
		</table>

	<h1 id="visitor_info">Visitor Information</h1>
	<br />

		<table summary="visitor_info" width="75%" id="greytable">
			<tbody id="greytbody">
				<tr>
					<td>Visitor's IP address:</td>
					<td><a href="<?php echo $ip_info_url . $visitor_ip; ?>" target="_blank"><?php echo $visitor_ip; ?></a></td>
				</tr>
				<tr class="odd">
					<td>Visitor's Hostname:</td>
					<td><?php echo $visitor_hostname; ?></td>
				</tr>
				<tr class="odd">
					<td>Visitor's User Agent:</td>
					<td><?php echo $visitor_agent; ?></td>
				</tr>
			</tbody>
		</table>

	<h1 id="other_info">Other Information</h1>
	<br />
		<table summary="other_info" width="75%" id="greytable">
			<tbody id="greytbody">
				<tr>
					<td>Time on page until click:</td>
					<td><?php echo seconds2minutes($timestamp - $disp_time); ?></td>
				</tr>
				<tr class="odd">
					<td>Ad Format:</td>
					<td>
						<?php echo $ad_width . "x" . $ad_height; ?>
					</td>
				</tr>
				<tr class="odd">
					<td>Background Color:</td>
					<td>
						<?php echo unset_if_string_empty($color_bg) . draw_color($color_bg, $gd_enabled); ?>
					</td>
				</tr>
				<tr class="odd">
					<td>Text Color:</td>
					<td>
						<?php echo unset_if_string_empty($color_txt) . draw_color($color_txt, $gd_enabled); ?>
					</td>
				</tr>
				<tr class="odd">
					<td>Link Color:</td>
					<td>
						<?php echo unset_if_string_empty($color_lnk) . draw_color($color_lnk, $gd_enabled); ?>
					</td>
				</tr>
				<tr class="odd">
					<td>URL Color:</td>
					<td>
						<?php echo unset_if_string_empty($color_url) . draw_color($color_url, $gd_enabled); ?>
					</td>
				</tr>
				<tr class="odd">
					<td>Border Color:</td>
					<td>
						<?php echo unset_if_string_empty($color_brd) . draw_color($color_brd, $gd_enabled); ?>
					</td>
				</tr>
				<tr class="odd">
					<td>Ad Type:</td>
					<td><?php echo ucfirst(str_replace('_i', '/I', $ad_type)) . ' ' . translateAdFormat($ad_format); ?>
					</td>
				</tr>
			</tbody>
		</table>

	<h1 id="visitor_stats">Visitor Click Statistics</h1>
	<p>Visitor's Performance:</p>

<?php
	/*
	 * Find out every click that this IP address has made
	 * on the site.
	 */
	$sql = "SELECT *
				FROM " . $db_table_prefix . "logfiles
					WHERE visitor_ip = '$visitor_ip'
						ORDER BY id DESC
							";
	$result = mysql_query("$sql");
		$total_visitor_clicks = mysql_num_rows($result);
?>
		<table summary="visitor_stats" width="25%" id="greytable">
			<thead id="greythead">
				<tr>
					<th scope="col">Visitor's Clicks</th>
				</tr>
			</thead>
			<tbody id="greytbody">
				<tr>
					<td align="center"><?php echo $total_visitor_clicks; ?></td>
				</tr>
			</tbody>
		</table>

	<p>Visitor Clicking History:</p>

		<table summary="visitor_clicks" width="90%" id="greytable">
			<thead id="greythead">
				<tr>
					<th scope="col" width="8%">More Info</th>
					<th scope="col" width="12%">Date</th>
					<th scope="col" width="12%">Time</th>
					<th scope="col" width="12%">Click Through Time</th>
					<th scope="col" width="56%">Page</th>
				</tr>
			</thead>

			<tbody id="greytbody">
				<?php
					while($row = mysql_fetch_array($result)) {
						$id = $row['id'];
						$timestamp = $row['timestamp'];
							$date = date('M j, Y', $timestamp);
							$time = date('g:i:s a', $timestamp);
						$disp_url = $row['disp_url'];
						$disp_time = $row['disp_time'];
				?>
						<tr class="odd">
							<td><a href="./click_info.php?id=<?php echo $id; ?>"><?php echo $total_visitor_clicks; ?></a></td>
							<td><?php echo $date; ?></td>
							<td><?php echo $time; ?></td>
							<td><?php echo seconds2minutes($timestamp - $disp_time); ?></td>
							<td><?php echo shortenURL($disp_url); ?></td>
						</tr>
				<?php $total_visitor_clicks--; } ?>
			</tbody>
		</table>

	<h1 id="visitor_blocks">Visitor Blocks</h1>
	<p>Information about whether this visitor was ever blocked from seeing ads.</p>

<?php
	/*
	 * Get all the times that ads were blocked
	 * for this IP address.
	 */
	$sql = "SELECT *
				FROM " . $db_table_prefix . "blocklogs
					WHERE visitor_ip = '$visitor_ip'";
	$result = mysql_query("$sql");
		$total_visitor_blocks = mysql_num_rows($result);
?>
		<table summary="visitor_blocks" width="50%" id="greytable">
			<thead id="greythead">
				<tr>
					<th scope="col" width="50%">Visitor's Blocks</th>
					<th scope="col" width="50%">More Info</th>
				</tr>
			</thead>
			<tbody id="greytbody">
				<tr>
					<td align="center"><?php echo $total_visitor_blocks; ?></td>
					<td align="center"><a href="./blocked_visitor.php?visitor_ip=<?php echo $visitor_ip; ?>">Click here</a>.</td>
				</tr>
			</tbody>
		</table>

	<?php if ($total_visitor_blocks > 0) { ?>

		<p>Visitor Blocking History:</p>

			<table summary="visitor_block_history" width="90%" id="greytable">
				<thead id="greythead">
					<tr>
						<th scope="col" width="10%">Block ID</th>
						<th scope="col" width="20%">Date</th>
						<th scope="col" width="20%">Time</th>
						<th scope="col" width="70%">Page</th>
					</tr>
				</thead>

				<tbody id="greytbody">
					<?php
						/*
						 * Loop through those block logs and show each
						 * and every time ads were blocked.
						 */
						while($row = mysql_fetch_array($result)) {
							$timestamp = $row['timestamp'];
								$date = date('M j, Y', $timestamp);
								$time = date('g:i:s a', $timestamp);
							$visitor_ip = $row['visitor_ip'];
							$blocked_url = $row['blocked_url'];
							
					?>
							<tr class="odd">
								<td><?php echo $total_visitor_blocks; ?></td>
								<td><?php echo $date; ?></td>
								<td><?php echo $time; ?></td>
								<td><?php echo shortenURL($blocked_url); ?></td>
							</tr>
					<?php
						$total_visitor_blocks--;
							}
					?>
				</tbody>
			</table>

	<?php } else { ?>
		<p><strong>This visitor has no blocked logs to display.</strong></p>
	<?php } ?>

	<h1 id="manage-logs">Manage Click Logs</h1>

<form name="drop_click" action="./manage_action.php?go=drop_click&amp;click_id=<?php echo $click_id; ?>" method="post">
	<p>
	To delete this click from your logs, click here: 
	<input type="submit" value="Delete" onclick="return confirmSubmit();" />
	</p>
</form>

<form name="dropyourself_all" action="./manage_action.php?go=dropyourself_all&amp;ref=./manage.php?logs" method="post">
	<input type="hidden" name="ip_delete" value="<?php echo $visitor_ip; ?>" />
		<p>
		To delete all clicks from this IP address, click here: 
		<input type="submit" value="Delete" onclick="return confirmSubmit();" />
		</p>
</form>

<form name="dropyourself_block" action="./manage_action.php?go=dropyourself_block&amp;ref=<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
	<input type="hidden" name="ip_delete" value="<?php echo $visitor_ip; ?>" />
		<p>
		To delete all blocks of this IP address, click here: 
		<input type="submit" value="Delete" onclick="return confirmSubmit();" />
		</p>
</form>

</div>

<?php bodyFooter('click_info', $start_time); ?>